/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

import intrinsic.mx.effects.CompositeEffect;

import org.eclipse.swt.SWT;

public class CompositeAnimation extends Animation {
	int childCount = 0;
	Animation[] animations = new Animation[4];

public void addAnimation(Animation animation) {
	if (animations.length == childCount) {
		Animation[] temp = new Animation[childCount + 4];
		System.arraycopy(animations, 0, temp, 0, childCount);
		animations = temp;
	}
	animations[childCount] = animation;
	childCount++;
}

void create () {
	super.create();
	CompositeEffect effect = (CompositeEffect)object;
	for (int i = 0; i < childCount; i++) {
		animations[i].create();
		effect.addChild(animations[i].object);
	}
}

public Animation getAnimation(int index) {
	checkAnimation();
	if (!(0 <= index && index < childCount)) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
	return animations[index];
}
	
void release() {
	for (int i = 0; i < childCount; i++) {
		animations[i].release();
	}
	super.release();
}
	
}
